#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

#define MAXN 10

int sle(int n, double a[], double x[]);
int isp(LINE l1, LINE l2, P2D *p);
double fdsymeq(int n, int i, double x[]);
int fdallsol(int degree, double c[], double z[]);

double seki(LINE l, P2D p)
{
    return l.a * p.x + l.b * p.y + l.c;
}

P2D p[MAXN];
LINE l[2 * MAXN];
double c[MAXN], d[MAXN * (MAXN - 1) / 2], e[MAXN], x[2 * MAXN], y[MAXN];

main(int argc, char *argv[])
{
    int i, j, k, m, n, dsp;
    double s, t, t2, a[2];

    if(argc < 5) {
	fprintf(stderr, "͸İʾɬפǤ\n");
	return 0;
    }
    n = (argc - 1) / 2;
    printf("circle 0 0 1\ncolor 0 3 0\n");
    for(i = 0; i < 2 * n; i++) {
	x[i] = t = atof(argv[i + 1]);
	t2 = t * t + 1.;
	l[i].a = 2. * t / t2;
	l[i].b = (t2 - 2.) / t2;
	l[i].c = -1.;
    }
    for(i = 0; i < n - 1; i++) {
	isp(l[n], l[n + i + 1], p + i);
    }
    for(i = m = 0; i < n - 1; i++) {
	for(j = 0; j < n; j++, m++) {
	    for(d[m] = 1., k = 0; k < n; k++) {
		if(k == j) continue;
		d[m] *= seki(l[k], p[i]);
	    }
	}
    }
    printf("color 3 0 0\n");
    if(n == 2) {
	printf("line %f %f %f\n", d[0] * l[0].a - d[1] * l[1].a, d[0] * l[0].b - d[1] * l[1].b, d[0] * l[0].c - d[1] * l[1].c);
    }
    else {
	sle(n, d, c);
	printf("curve ");
	for(i = 0; i < n; i++) {
	    if(i > 0 && c[i] > 0.) printf("+");
	    printf("%f", c[i]);
	    for(j = 0; j < n; j++) {
		if(j == i) continue;
		printf("(%fx+%fy+%f)", l[j].a, l[j].b, l[j].c);
	    }
	}
	printf("\n");
    }
    for(c[0] = d[0] = 1., i = 1; i <= n; i++) {
	if((i % 2) == 0) {
	    c[i] = fdsymeq(n, i, x);
	    d[i] = fdsymeq(n, i, x + n);
	}
	else {
	    c[i] = -fdsymeq(n, i, x);
	    d[i] = -fdsymeq(n, i, x + n);
	}
    }
    for(i = 0; i <= n; i++) e[i] = 2 * c[i] + d[i];
    if(fdallsol(n, e, y) < n) return 0;
    printf("color 2 3 0\n");
    for(i = 0; i < n; i++) {
	t = y[i];
	t2 = t * t + 1.;
	l[i].a = 2. * t / t2;
	l[i].b = (t2 - 2.) / t2;
	l[i].c = -1.;
    }
    for(i = 0; i <= n; i++) e[i] = 2 * c[i] - d[i];
    if(fdallsol(n, e, y) < n) return 0;
    for(i = 0; i < n; i++) {
	t = y[i];
	t2 = t * t + 1.;
	l[n + i].a = 2. * t / t2;
	l[n + i].b = (t2 - 2.) / t2;
	l[n + i].c = -1.;
    }
    for(a[1] = 1., i = 0; i < n; i++) a[1] *= seki(l[i], p[0]);
    for(a[0] = -1.; i < 2 * n; i++) a[0] *= seki(l[i], p[0]);
    printf("color 3 2 0\ncurve %f", a[0]);
    for(i = 0; i < n; i++) printf("(%fx+%fy+%f)", l[i].a, l[i].b, l[i].c);
    if(a[1] > 0.) printf("+");
    printf("%f", a[1]);
    for( ; i < 2 * n; i++) printf("(%fx+%fy+%f)", l[i].a, l[i].b, l[i].c);
    printf("\n");
    for(dsp = 1, s = 0. ; s < 1.; s += .01) {
	printf("copy 0 %d\nactive %d\ncolor 0 3 0\n", dsp, dsp);
	for(i = 0; i <= n; i++) e[i] = (1. - s) * c[i] + s * d[i];
	m = fdallsol(n, e, y);
	for(i = 0; i < m; i++) {
	    t = y[i];
	    t2 = t * t + 1.;
	    printf("line %f %f -1.\n", 2. * t / t2, (t2 - 2.) / t2);
	}
	printf("color 0 0 3\n");
	for(i = 0; i <= n; i++) e[i] = (1. - s) * c[i] - s * d[i];
	m = fdallsol(n, e, y);
	for(i = 0; i < m; i++) {
	    t = y[i];
	    t2 = t * t + 1.;
	    printf("line %f %f -1.\n", 2. * t / t2, (t2 - 2.) / t2);
	}
	printf("display %d\ntsleep 50\n", dsp);
	if(dsp == 1) dsp = 2;
	else dsp = 1;
    }
    for(s = 1. ; s > 0.; s -= .01) {
	printf("copy 0 %d\nactive %d\ncolor 0 3 0\n", dsp, dsp);
	for(i = 0; i <= n; i++) e[i] = (1. - s) * c[i] - s * d[i];
	m = fdallsol(n, e, y);
	for(i = 0; i < m; i++) {
	    t = y[i];
	    t2 = t * t + 1.;
	    printf("line %f %f -1.\n", 2. * t / t2, (t2 - 2.) / t2);
	}
	printf("color 0 0 3\n");
	for(i = 0; i <= n; i++) e[i] = (1. - s) * c[i] + s * d[i];
	m = fdallsol(n, e, y);
	for(i = 0; i < m; i++) {
	    t = y[i];
	    t2 = t * t + 1.;
	    printf("line %f %f -1.\n", 2. * t / t2, (t2 - 2.) / t2);
	}
	printf("display %d\ntsleep 50\n", dsp);
	if(dsp == 1) dsp = 2;
	else dsp = 1;
    }
    return 0;
}
