#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

#define MAXN 5

int sle(int n, double a[], double x[]);
int isp(LINE l1, LINE l2, P2D *p);

double seki(LINE l, P2D p)
{
    return l.a * p.x + l.b * p.y + l.c;
}

P2D p[MAXN];
LINE l[MAXN * 2];
double c[MAXN], d[MAXN * (MAXN - 1) / 2];

main(int argc, char *argv[])
{
    int i, j, k, m, n;
    double t;

    if(argc < 7) {
	fprintf(stderr, "ϻİʾɬפǤ\n");
	return 0;
    }
    n = (argc - 1) / 2;
    printf("circle 0 0 1\ncolor 0 3 0\n");
    for(i = 0; i < 2 * n; i++) {
	t = atof(argv[i + 1]);
	l[i].a = cos(t);
	l[i].b = sin(t);
	l[i].c = -1.;
	if(i == n) printf("color 0 0 3\n");
	printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    }
    for(i = 0; i < n - 1; i++) isp(l[n], l[n + i + 1], p + i);
    for(i = m = 0; i < n - 1; i++) {
	for(j = 0; j < n; j++, m++) {
	    for(d[m] = 1., k = 0; k < n; k++) {
		if(k == j) continue;
		d[m] *= seki(l[k], p[i]);
	    }
	}
    }
    sle(n, d, c);
    printf("color 3 0 0\ncurve ");
    for(i = 0; i < n; i++) {
	if(i > 0 && c[i] > 0.) printf("+");
	printf("%f", c[i]);
	for(j = 0; j < n; j++) {
	    if(j == i) continue;
	    printf("(%fx+%fy+%f)", l[j].a, l[j].b, l[j].c);
	}
    }
    printf("\n");
    return 0;
}
