#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

#define MAXN 10

int lnth2pts(P2D p1, P2D p2, LINE *l);

P2D pt[MAXN];
LINE l[MAXN], m[MAXN];

main(int argc, char *argv[])
{
    int i, n;
    double t, c, d;

    if(argc < 4 || argc >= MAXN) exit(0);
    n = argc - 1;
    printf("gray 0\ncircle 0 0 1.\ncolor 0 3 0\n");
    for(i = 0; i < n; i++) {
	t = atof(argv[i + 1]);
	l[i].a = pt[i].x = cos(t);
	l[i].b = pt[i].y = sin(t);
	l[i].c = -1.;
	printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    }
    pt[n] = pt[0];
    printf("color 0 0 3\n");
    for(i = 0; i < n; i++) {
	lnth2pts(pt[i], pt[i + 1], m + i);
	printf("line %f %f %f\n", m[i].a, m[i].b, m[i].c);
    }
    for(i = 0, c = 1., d = -1.; i < n; i++) {
	c *= (m[i].a - m[i].c);
	d *= (l[i].a - l[i].c);
    }
    printf("color 3 0 0\ncurve %f", c);
    for(i = 0; i < n; i ++) printf("(%fx+%fy+%f)", l[i].a, l[i].b, l[i].c);
    if(d >= 0.) printf("+");
    printf("%f", d);
    for(i = 0; i < n; i++) printf("(%fx+%fy+%f)", m[i].a, m[i].b, m[i].c);
    printf("\n");
    return 0;
}
