#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

#define MAXN 20

int lnth2pts(P2D p1, P2D p2, LINE *l);

P2D pt[MAXN];
LINE ln[MAXN];

main(int argc, char *argv[])
{
    int i, n;
    double t, c, d;

    if(argc < 7 || argc > MAXN - 1) exit(0);
    n = argc - 1;
    if((n % 2) > 0) n--;
    for(i = 0; i < n; i++) {
	t = atof(argv[i + 1]);
	pt[i].x = cos(t);
	pt[i].y = sin(t);
	//	printf("%f %f\n", pt[i].x, pt[i].y);
    }
    pt[n] = pt[0];
    printf("gray 0\ncircle 0 0 1.\n");
    for(i = 0; i < n; i++) {
	lnth2pts(pt[i], pt[i + 1], ln + i);
	if((i % 2) == 0) printf("color 0 0 3\n");
	else printf("color 0 3 0\n");
	printf("line %f %f %f\n", ln[i].a, ln[i].b, ln[i].c);
    }
    for(i = 1, c = 1.; i < n; i += 2) c *= (ln[i].a - ln[i].c);
    for(i = 0, d = -1.; i < n; i += 2) d *= (ln[i].a - ln[i].c);
    printf("color 3 0 0\ncurve %f", c);
    for(i = 0; i < n; i += 2) printf("(%fx+%fy+%f)", ln[i].a, ln[i].b, ln[i].c);
    if(d >= 0.) printf("+%f", d);
    else printf("%f", d);
    for(i = 1; i < n; i += 2) printf("(%fx+%fy+%f)", ln[i].a, ln[i].b, ln[i].c);
    printf("\n");
    return 0;
}

