#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

int sle(int n, double a[], double x[]);

#define MAXN 6

LINE l[MAXN];
double c[MAXN], d[MAXN * (MAXN - 1)], w[MAXN];

main(int argc, char *argv[])
{
    int i, j, k = 0, n;
    double t, u, v;

    if(argc < 4) {
	fprintf(stderr, "ϻİʾɬפǤ\n");
	return 0;
    }
    if(argc > MAXN + 1) {
	fprintf(stderr, "%dİʲˤƲ\n", MAXN);
	argc = 7;
    }
    else n = argc - 1;
    printf("circle 0 0 1\ncolor 0 0 3\n");
    for(i = 0; i < n; i++) {
	t = atof(argv[i + 1]);
	l[i].a = cos(t);
	l[i].b = sin(t);
	l[i].c = -1.;
	printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    }
    for(i = 0, u = 1.; i < n; i++) u *= (w[i] = l[i].a * 2. + l[i].c);
    for(i = 0; i < n; i++) d[k++] = u / w[i];
    for(i = 0, v = 0.; i < n; i++) v += l[i].a / w[i];
    for(i = 0; i < n; i++) d[k++] = u * (v - l[i].a / w[i]) / w[i];
    for(i = 0, v = 0.; i < n; i++) v += l[i].b / w[i];
    for(i = 0; i < n; i++) d[k++] = u * (v - l[i].b / w[i]) / w[i];
    /*
    for(i = 0, u = 1.; i < n; i++) u *= l[i].c;
    for(i = 0; i < n; i++) d[k++] = u / l[i].c;
    for(i = 0, v = 0.; i < n; i++) v += l[i].a / l[i].c;
    for(i = 0; i < n; i++) d[k++] = u * (v - l[i].a / l[i].c) / l[i].c;
    for(i = 0, v = 0.; i < n; i++) v += l[i].b / l[i].c;
    for(i = 0; i < n; i++) d[k++] = u * (v - l[i].b / l[i].c) / l[i].c;
    */
    /*
    for(i = 0, u = 1.; i < n; i++) u *= l[i].a * .5 + l[i].c;
    for(i = 0; i < n; i++) d[k++] = u / (l[i].a * .5 + l[i].c);
    for(i = 0, u = 1.; i < n; i++) u *= l[i].b * .5 + l[i].c;
    for(i = 0; i < n; i++) d[k++] = u / (l[i].b * .5 + l[i].c);
    */
    sle(n, d, c);
    printf("color 3 0 0\ncurve ");
    for(i = 0; i < n; i++) {
	if((i > 0) && (c[i] > 0.)) printf("+");
	printf("%f", c[i]);
	for(j = 0; j < n; j++) {
	    if(j == i) continue;
	    printf("(%fx+%fy+%f)", l[j].a, l[j].b, l[j].c);
	}
    }
    printf("\n");
    return 0;
}

