#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

int sle(int n, double a[], double x[]);
int isp(LINE l1, LINE l2, P2D *p);
int lnth2pts(P2D p1, P2D p2, LINE *l);

P2D p[6], q[3], r[2];
LINE l[6], m[3];

main(int argc, char *argv[])
{
    int i, j, k;
    double t, a2b2, x2y2, a[3], c[6];

    if(argc < 4) {
	fprintf(stderr, "ɬפǤ\n");
	return 0;
    }
    printf("circle 0 0 1\ncolor 0 3 0\n");
    for(i = 0; i < 3; i++) {
	t = atof(argv[i + 1]);
	l[i].a = p[i].x = cos(t);
	l[i].b = p[i].y = sin(t);
	l[i].c = -1.;
	printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    }
    isp(l[1], l[2], q);
    isp(l[0], l[2], q + 1);
    isp(l[0], l[1], q + 2);
    printf("color 3 0 0\n");
    for(i = 0; i < 3;  i++) {
	lnth2pts(p[i], q[i], m + i);
	a2b2 = m[i].a * m[i].a + m[i].b * m[i].b;
	l[i + 3].a = p[i + 3].x = -p[i].x - 2. * m[i].a * m[i].c / a2b2;
	l[i + 3].b = p[i + 3].y = -p[i].y - 2. * m[i].b * m[i].c / a2b2;
	l[i + 3].c = -1.;
	//	printf("disk %f %f .03\n", p[i + 3].x, p[i + 3].y);
	printf("line %f %f %f\n", m[i].a, m[i].b, m[i].c);
    }
    for(k = i = 0; i < 2; i++) {
	isp(l[3], m[i + 1], r + i);
	//	printf("disk %f %f .05\n", r[i].x, r[i].y);
	c[k++] = (l[1].a * r[i].x + l[1].b * r[i].y + l[1].c) * (l[2].a * r[i].x + l[2].b * r[i].y + l[2].c);
	c[k++] = (l[0].a * r[i].x + l[0].b * r[i].y + l[0].c) * (l[2].a * r[i].x + l[2].b * r[i].y + l[2].c);
	c[k++] = (l[0].a * r[i].x + l[0].b * r[i].y + l[0].c) * (l[1].a * r[i].x + l[1].b * r[i].y + l[1].c);
    }
    printf("color 0 3 0\n");
    for(i = 3; i < 6; i++) printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    sle(3, c, a);
    printf("color 3 0 0\ncurve ");
    for(i = 0; i < 3; i++) {
	if((i > 0) && a[i] > 0.) printf("+");
	printf("%f", a[i]);
	for(j = 0; j < 3; j++) {
	    if(j == i) continue;
	    printf("(%fx+%fy+%f)", l[j].a, l[j].b, l[j].c);
	}
    }
    printf("\ncolor 0 0 3\n");
    if(argc > 4) t = atof(argv[4]);
    else t = .1;
    p[0].x = l[0].a = cos(t);
    p[0].y = l[0].b = sin(t);
    l[0].c = -1.;
    for(i = 0; i < 5; i++) {
        printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
	isp(l[i], m[i % 2], q);
	x2y2 = q[0].x * q[0].x + q[0].y * q[0].y;
	p[i + 1].x = l[i + 1].a = 2. * q[0].x / x2y2 - p[i].x;
	p[i + 1].y = l[i + 1].b = 2. * q[0].y / x2y2 - p[i].y;
    }
    printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    return 0;
}
