#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

int sle(int n, double a[], double x[]);
int isp(LINE l1, LINE l2, P2D *p);
int lnth2pts(P2D p1, P2D p2, LINE *l);

double seki(LINE l, P2D p)
{
    return l.a * p.x + l.b * p.y + l.c;
}

P2D p[6], q[3];
LINE l[6], m;

main(int argc, char *argv[])
{
    int i, j, k;
    double t, a2b2, x2y2, c[4], d[6];

    if(argc < 6) {
	fprintf(stderr, "ޤɬפǤ\n");
	return 0;
    }
    printf("circle 0 0 1\ncolor 0 3 0\n");
    for(i = 0; i < 5; i++) {
	t = atof(argv[i + 1]);
	l[i].a = p[i].x = cos(t);
	l[i].b = p[i].y = sin(t);
	l[i].c = -1.;
    }
    isp(l[0], l[1], q);
    isp(l[2], l[3], q + 1);
    lnth2pts(q[0], q[1], &m);
    isp(l[4], m, q + 2);
    x2y2 = q[2].x * q[2].x + q[2].y * q[2].y;
    l[5].a = -l[4].a + 2 * q[2].x / x2y2;
    l[5].b = -l[4].b + 2 * q[2].y / x2y2;
    l[5].c = l[4].c;
    for(i = 0; i < 5; i += 2) printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    printf("color 0 0 3\n");
    for(i = 1; i < 6; i += 2) printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    isp(l[1], l[3], p);
    d[0] = seki(l[0], p[0]) * seki(l[2], p[0]);
    d[1] = seki(l[4], p[0]) * seki(l[2], p[0]);
    d[2] = seki(l[4], p[0]) * seki(l[0], p[0]);
    isp(l[5], l[3], p);
    d[3] = seki(l[0], p[0]) * seki(l[2], p[0]);
    d[4] = seki(l[4], p[0]) * seki(l[2], p[0]);
    d[5] = seki(l[4], p[0]) * seki(l[0], p[0]);
    sle(3, d, c);
    printf("color 3 0 0\nline %f %f %f\ncurve ", m.a, m.b, m.c);
    printf("%f(%fx+%fy+%f)(%fx+%fy+%f)", c[0], l[0].a, l[0].b, l[0].c, l[2].a, l[2].b, l[2].c);
    if(c[1] > 0.) printf("+");
    printf("%f(%fx+%fy+%f)(%fx+%fy+%f)", c[1], l[4].a, l[4].b, l[4].c, l[2].a, l[2].b, l[2].c);
    if(c[2] > 0.) printf("+");
    printf("%f(%fx+%fy+%f)(%fx+%fy+%f)", c[2], l[4].a, l[4].b, l[4].c, l[0].a, l[0].b, l[0].c);
    q[2].x = (q[0].x + q[1].x) / 2.; q[2].y = (q[0].y + q[1].y) / 2.;
    for(i = 0, c[1] = -1.; i < 5; i += 2) c[1] *= seki(l[i], q[2]);
    for(i = 1, c[0] = 1.; i < 6; i += 2) c[0] *= seki(l[i], q[2]);
    printf("\ncolor 3 2 0\ncurve %f", c[0]);
    for(i = 0; i < 5; i += 2) printf("(%fx+%fy+%f)", l[i].a, l[i].b, l[i].c);
    if(c[1] > 0.) printf("+");
    printf("%f", c[1]);
    for(i = 1; i < 6; i += 2) printf("(%fx+%fy+%f)", l[i].a, l[i].b, l[i].c);
    printf("\n");
    return 0;
}
