#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

int sle(int n, double a[], double x[]);
int isp(LINE l1, LINE l2, P2D *p);

double seki(LINE l, P2D p)
{
    return l.a * p.x + l.b * p.y + l.c;
}

P2D p[6];
LINE l[6];

main(int argc, char *argv[])
{
    int i, j, k;
    double t, a2b2, x2y2, c[4], d[6];

    if(argc < 7) {
	fprintf(stderr, "ϻɬפǤ\n");
	return 0;
    }
    printf("circle 0 0 1\ncolor 0 3 0\n");
    for(i = 0; i < 6; i++) {
	t = atof(argv[i + 1]);
	l[i].a = p[i].x = cos(t);
	l[i].b = p[i].y = sin(t);
	l[i].c = -1.;
    }
    for(i = 0; i < 5; i += 2) printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    printf("color 0 0 3\n");
    for(i = 1; i < 6; i += 2) printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    isp(l[1], l[3], p);
    d[0] = seki(l[0], p[0]) * seki(l[2], p[0]);
    d[1] = seki(l[4], p[0]) * seki(l[2], p[0]);
    d[2] = seki(l[4], p[0]) * seki(l[0], p[0]);
    isp(l[5], l[3], p);
    d[3] = seki(l[0], p[0]) * seki(l[2], p[0]);
    d[4] = seki(l[4], p[0]) * seki(l[2], p[0]);
    d[5] = seki(l[4], p[0]) * seki(l[0], p[0]);
    sle(3, d, c);
    printf("color 3 0 0\ncurve ");
    printf("%f(%fx+%fy+%f)(%fx+%fy+%f)", c[0], l[0].a, l[0].b, l[0].c, l[2].a, l[2].b, l[2].c);
    if(c[1] > 0.) printf("+");
    printf("%f(%fx+%fy+%f)(%fx+%fy+%f)", c[1], l[4].a, l[4].b, l[4].c, l[2].a, l[2].b, l[2].c);
    if(c[2] > 0.) printf("+");
    printf("%f(%fx+%fy+%f)(%fx+%fy+%f)", c[2], l[4].a, l[4].b, l[4].c, l[0].a, l[0].b, l[0].c);
    printf("\ncolor 3 2 0\ncurve ");
    for(i = 0; i < 5; i += 2) printf("(%fx+%fy+%f)", l[i].a, l[i].b, l[i].c);
    printf("+");
    for(i = 1; i < 6; i += 2) printf("(%fx+%fy+%f)", l[i].a, l[i].b, l[i].c);
    printf("\n");
    return 0;
}
