#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "plane.h"

int sle(int n, double a[], double x[]);
int isp(LINE l1, LINE l2, P2D *p);
int lnth2pts(P2D p1, P2D p2, LINE *l);

double seki(LINE l, P2D p)
{
    return l.a * p.x + l.b * p.y + l.c;
}

P2D p[6], q[3];
LINE l[6], m;

//double c[3], x1[3];

main(int argc, char *argv[])
{
    int i, j, k;
    double t, a2b2, x2y2, c[4], d[6];

    if(argc < 6) {
	fprintf(stderr, "ޤɬפǤ\n");
	return 0;
    }
    printf("circle 0 0 1\ncolor 0 0 3\n");
    for(i = 0; i < 5; i++) {
	t = atof(argv[i + 1]);
	l[i].a = p[i].x = cos(t);
	l[i].b = p[i].y = sin(t);
	l[i].c = -1.;
    }
    isp(l[0], l[1], q);
    isp(l[2], l[3], q + 1);
    lnth2pts(q[0], q[1], &m);
    isp(l[4], m, q + 2);
    x2y2 = q[2].x * q[2].x + q[2].y * q[2].y;
    l[5].a = -l[4].a + 2 * q[2].x / x2y2;
    l[5].b = -l[4].b + 2 * q[2].y / x2y2;
    l[5].c = l[4].c;
    for(i = 0; i < 6; i++) printf("line %f %f %f\n", l[i].a, l[i].b, l[i].c);
    printf("color 3 0 0\nline %f %f %f\ncurve ", m.a, m.b, m.c);
    for(i = 0; i < 3; i++) {
	if(i > 0) printf("-");
	for(j = 0; j < 3; j++) {
	    if(j == i) continue;
	    printf("(%fx+%fy+%f)(%fx+%fy+%f)", l[2 * j].a, l[2 * j].b, l[2 * j].c, l[2 * j + 1].a, l[2 * j + 1].b, l[2 * j + 1].c);
	}
    }
    printf("\n");
    return 0;
}
